'use strict';

function ResultsRankingCtrl($scope, $rootScope, RankingManager, $http, AppConfig){
    $scope.rankingLoaded = false;
    $scope.groups = [];
    $scope.start_after = '';
    $scope.end_before = '';

    var today = new Date();
    if(today.getTime() < new Date(today.getFullYear(), 1, 1).getTime()){
        $scope.start_after = (today.getFullYear()-1)+'-09-01 00:00:00';
        $scope.end_before = (today.getFullYear())+'-01-31 23:59:59';
    } else if(today.getTime() <= new Date(today.getFullYear(), 7, 31).getTime()){
        $scope.start_after = (today.getFullYear())+'-02-01 00:00:00';
        $scope.end_before = (today.getFullYear())+'-08-31 23:59:59';
    } else {
        $scope.start_after = (today.getFullYear())+'-09-01 00:00:00';
        $scope.end_before = (today.getFullYear()+1)+'-01-31 23:59:59';
    }

    $scope.loadRanking = function() {
        RankingManager.loadData($scope.start_after, $scope.end_before).then(function(data){
            $scope.groups = $.map(data, function(value, index) {
                value.profit_sum = parseFloat(value.profit_sum);
                value.income_sum = parseFloat(value.income_sum);
                return [value];
            });
            $scope.rankingLoaded = true;
        });
    }

    $scope.datesCorrect = function(){
        return  $scope.start_after !== '' &&
                $scope.start_after !== null &&
                typeof $scope.start_after !== 'undefined' &&
                $scope.end_before !== '' &&
                $scope.end_before !== null &&
                typeof $scope.end_before !== 'undefined' &&
                $scope.end_before > $scope.start_after;
    }

    $scope.loadRanking();

    $scope.formatNumber = function(number)
    {
        number = number.toFixed(2) + '';
        var x = number.split('.');
        var x1 = x[0];
        var x2 = x.length > 1 ? '.' + x[1] : '';
        var rgx = /(\d+)(\d{3})/;
        while (rgx.test(x1)) {
            x1 = x1.replace(rgx, '$1' + ',' + '$2');
        }
        return x1 + x2;
    }
}

ResultsRankingCtrl.$inject = ['$scope', '$rootScope', 'RankingManager', '$http', 'AppConfig'];